

;;Principal Components and Multivariate Regression Example

;;These commands expand both sets of data by sampling from sample,
;;then do a principal components analysis of car preferences
;;followed by a multivariate regression analysis that projects 
;;car ratings into the principal components space, and a cluster
;;analysis of the principal scores.

; sampling from sample

(defun pca-mmr-demo ()
(setf *demo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))
(defun random-resample (dob ns percent)
  (let* ((sample (send dob :data-matrix))
         (stdvs (mapcar #'(lambda (var) (standard-deviation var)) 
                        (column-list sample)))
         (one-resample)
         (all-resamples)
         (nr (array-dimension sample 0))
         (nc (array-dimension sample 1))
         )

    (dotimes (i ns)
             (setf one-resample
                   (apply #'bind-columns 
                    (mapcar 
                     #'(lambda (col j)
                         (+ col
                            (* (normal-rand nr)
                               percent
                               (select stdvs j))))
                     (column-list sample) (iseq nc))))
             (setf all-resamples
                   (if (= i 0)
                       one-resample
                       (bind-columns all-resamples one-resample))))
    all-resamples))

(defun random-resamples (dob n-samples percent)
"Makes a new data object by resampling fro DOB N-SAMPLES times with PERCENT error"
  (let* ((random-resampled-data-matrix
          (random-resample dob n-samples percent))
         (title (format nil "~a*~d"n-samples (send dob :name)))
         (labels (send dob :labels))
         (labels (combine (mapcar #'(lambda (val) (repeat val n-samples)) labels)))
         ;(labels (repeat  (send dob :labels) n-samples))
         (variables (send dob :variables))
         )
    (data title
          :variables variables
          :labels labels
          :data (combine (row-list random-resampled-data-matrix))
          :use dob
          )))

(load-data (strcat *demo-data-path* "carrats.lsp"))
(random-resamples $ 20 .5)
(standardize-data)
(setf normed-data $)

(load-data (strcat *demo-data-path* "carprf14.lsp"))
(random-resamples $ 20 .5)

(principal-components)
(create-data)
;(visualize-data)


;(setcd scores-pca-car-prefs)
(setcd normed-data)
(merge-variables "rats-scores")
(setf rat-scores $)
(multivariate-regression
 :data rat-scores
 :redundancy 2
 :responses (send carratings :variables)
 :predictors '("PC1" "PC2" "PC3" "PC4" "PC5"))
(create-data)
(setf scores-prncmp $)
(visualize-model)

(setcd scores-prncmp)
;(cluster-analysis)


(setcd scores-prncmp)
(visualize-data)

)
(pca-mmr-demo )